#ifndef _HEADERS_FUNCTIONS_H
#define _HEADERS_FUNCTIONS_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int SendNextStatement(int Client)
{
    SQLINTEGER StatementLen = 0;
    SQLCHAR Statement[1024 + 1];
    SQLINTEGER ImportTableLen = 0;
    SQLCHAR ImportTable[32 + 1];
    char StatusText[255];

    char SendData[MaxReceiveSize + 1];

    if(!DBFetch(CI[Client].StatementsHandle))
    {
        // This is not an error. It means there are no more rows.
        DBCloseCursor(CI[Client].StatementsHandle);
        CI[Client].StatementsHandle = NULL;
        return SENDNEXTSTATEMENT_DONE;
    }

    if(!DBGetData(CI[Client].StatementsHandle, 1, SQL_C_CHAR, Statement, 1024, &StatementLen))
    {
        sprintf(StatusText, "(%d) DBGetData Statement error.", MyServer.ClientID[Client]);
        WriteLog(StatusText);

        DBCloseCursor(CI[Client].StatementsHandle);
        glErrorCount++;
        return SENDNEXTSTATEMENT_FAILURE;
    }
    if(StatementLen == -1)
	{
	    DBCloseCursor(CI[Client].StatementsHandle);
		return SENDNEXTSTATEMENT_FAILURE;
	}

    if(!DBGetData(CI[Client].StatementsHandle, 2, SQL_C_CHAR, ImportTable, 32, &ImportTableLen))
    {
        sprintf(StatusText, "(%d) DBGetData ImportTable error.", MyServer.ClientID[Client]);
        WriteLog(StatusText);
        DBCloseCursor(CI[Client].StatementsHandle);
        glErrorCount++;
        return SENDNEXTSTATEMENT_FAILURE;
    }
    if(StatementLen == -1)
	{
	    DBCloseCursor(CI[Client].StatementsHandle);
		return SENDNEXTSTATEMENT_FAILURE;
	}

    sprintf(SendData, "::ImportTable:%s", ImportTable);
    SimpleServerSend(Client, SendData);

    sprintf(SendData, "::Statement:%s", Statement);
    SimpleServerSend(Client, SendData);

    return SENDNEXTSTATEMENT_SUCCESS;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool IsValidCompanyPassword(int Client)
{
    char Statement[255];
    char StatusTemp[255];

    sprintf(Statement, "SELECT CompanyDatabase FROM Companys WHERE CompanyName = '%s' AND CompanyPassword = '%s'", CI[Client].CompanyName, CI[Client].CompanyPassword);

    HSTMT StatementHandle = NULL;

    if(!CI[Client].WPIndexDB.DBExecute(Statement, &StatementHandle))
    {
        sprintf(StatusTemp, "(%d) Error in IsValidCompanyPassword :: DBexecute failed.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);
        glErrorCount++;
        return false;
    }

    SQLINTEGER outRowCount = 0;
    if(SQLRowCount(StatementHandle, &outRowCount) != SQL_SUCCESS)
    {
        sprintf(StatusTemp, "(%d) Error in IsValidCompanyPassword :: SQLRowCount failed.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        DBCloseCursor(StatementHandle);
        glErrorCount++;
        return false;
    }

    if(outRowCount != 1)
        return false;

    if(!DBFetch(StatementHandle))
    {
        sprintf(StatusTemp, "(%d) Error in IsValidCompanyPassword :: DBFetch failed.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        DBCloseCursor(StatementHandle);
        glErrorCount++;
        return false;
    }

    SQLINTEGER DataLength = 0;
    SQLCHAR SQLBuffer[25 + 1];

    if(!DBGetData(StatementHandle, 1, SQL_C_CHAR, SQLBuffer, 25, &DataLength))
    {
        sprintf(StatusTemp, "(%d) Error in IsValidCompanyPassword :: DBGetData failed.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        DBCloseCursor(StatementHandle);
        glErrorCount++;
        return false;
    }

    if(DataLength == -1)
	{
	    DBCloseCursor(StatementHandle);
		return false;
	}

    memcpy(CI[Client].CompanyDB, SQLBuffer, DataLength);

    DBCloseCursor(StatementHandle);

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int IsValidClientVersion(int Client, char *UpdateHTTPURL)
{
    char Statement[255];
    char StatusTemp[255];

	sprintf(Statement, "SELECT Status, UpdateURL FROM ClientVersions WHERE Version = '%s'", CI[Client].ClientVersion);

    HSTMT StatementHandle = NULL;

    if(!CI[Client].WPIndexDB.DBExecute(Statement, &StatementHandle))
    {
        sprintf(StatusTemp, "(%d) Error in IsValidClientVersion :: DBExecute failed.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        glErrorCount++;
        return CLIENTVER_ERROR;
    }

    SQLINTEGER outRowCount = 0;
    if(SQLRowCount(StatementHandle, &outRowCount) != SQL_SUCCESS)
    {
        sprintf(StatusTemp, "(%d) Error in IsValidClientVersion :: SQLRowCount failed.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        DBCloseCursor(StatementHandle);
        glErrorCount++;
        return CLIENTVER_ERROR;
    }

    if(outRowCount == 0)
    {
        sprintf(StatusTemp, "(%d) Error in IsValidClientVersion :: Unknown client version: '%s'.", MyServer.ClientID[Client], CI[Client].ClientVersion);
        WriteLog(StatusTemp);

        DBCloseCursor(StatementHandle);
        glErrorCount++;
        return CLIENTVER_ERROR;
    }

    if(!DBFetch(StatementHandle))
    {
        sprintf(StatusTemp, "(%d) Error in IsValidClientVersion :: DBFetch failed.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        DBCloseCursor(StatementHandle);
        glErrorCount++;
        return CLIENTVER_ERROR;
    }

    SQLINTEGER DataLength = 0;
    SQLCHAR ClientVersion[25 + 1];

    if(!DBGetData(StatementHandle, 1, SQL_C_CHAR, ClientVersion, 25, &DataLength))
    {
        sprintf(StatusTemp, "(%d) Error in IsValidClientVersion :: DBGetData 1 failed.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        DBCloseCursor(StatementHandle);
        glErrorCount++;
        return CLIENTVER_ERROR;
    }
    ClientVersion[DataLength] = '\0';

    if(!DBGetData(StatementHandle, 2, SQL_C_CHAR, UpdateHTTPURL, 1024, &DataLength))
    {
        sprintf(StatusTemp, "(%d) Error in IsValidClientVersion :: DBGetData 2 failed.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        DBCloseCursor(StatementHandle);
        glErrorCount++;
        return CLIENTVER_ERROR;
    }
    UpdateHTTPURL[DataLength] = '\0';

    DBCloseCursor(StatementHandle);

    if(strcmpi((char *)ClientVersion, "current") == 0){ // Current version
        return CLIENTVER_CURRENT;
    }
    else if(strcmpi((char *)ClientVersion, "supported") == 0){ // Old but supported
        return CLIENTVER_SUPPORTED;
    }
    else if(strcmpi((char *)ClientVersion, "outdated") == 0){ // Old and nolonger supported
        return CLIENTVER_OUTDATED;
    }
    else if(strcmpi((char *)ClientVersion, "autoupdate") == 0){ // Old and nolonger supported
        return CLIENTVER_AUTOUPDATE;
    }
    else{
        sprintf(StatusTemp, "(%d) Error in IsValidClientVersion :: Unknown version identifier: '%s'.", MyServer.ClientID[Client], (char *)ClientVersion);
        WriteLog(StatusTemp);
        glErrorCount++;
        return CLIENTVER_ERROR;
    }

    return CLIENTVER_ERROR;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FatalError(char *xMessage)
{
    MessageBox(GetActiveWindow(), xMessage, TitleCaption, MB_ICONHAND + MB_SYSTEMMODAL);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteLog(char *xMessage)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);

    char lsDate[64];
    char lsTime[64];

    GetDateFormat(LOCALE_USER_DEFAULT,DATE_SHORTDATE,&ST,NULL,lsDate,64);
    GetTimeFormat(LOCALE_USER_DEFAULT,0,&ST,NULL,lsTime,64);

    fprintf(gfSessionLog, "(%s %s) | %s\r\n", lsDate, lsTime, xMessage);
    InsertListBoxItem(SDI.ServerList_hWnd, xMessage, -1);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool WaitOnApplicationToExit(void)
{
    gbKillApplication = true; // Tell application to exit

    if(gbConsoleOpen)
    {
        CloseConsole();
    }

    if(gbIsServerDialogOpen)
    {
        EndDialog(ServerDialog_hWnd, 0);
    }

    while(gbApplicationRunning) // Wait on application to exit
    {
        Sleep(1);
    }

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool xMainEntry(void)
{
    gbApplicationRunning = true;

    if(!Initialize())
    {
        gbApplicationRunning = false;
        return false;
    }

    if(!StartServer())
    {
        // Already handled
    }

    while(!gbKillApplication)
    {
    	if(WaitForSingleObject(OpenISQLExgServerMainDialog_Handle, 0) == WAIT_OBJECT_0)
        {
            DialogBox(MainInstance, MAKEINTRESOURCE(IDD_SERVER), 0, ServerDialog);
        }
    	if(WaitForSingleObject(OpenISQLExgServerConsole_Handle, 0) == WAIT_OBJECT_0)
        {
            OpenConsole();
        }

        Sleep(1);
    }

    if(!StopServer())
    {
        //Already handled
    }

    if(!Uninitialize())
    {
        gbApplicationRunning = false;
        return false;
    }

    gbApplicationRunning = false;

	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CreateFolderStructure(char *FullFileName)
{
    char Directory[256];

    int NameLength = strlen(FullFileName);
    int Position = 0;

    while(Position < NameLength)
    {
        if(FullFileName[Position] == '\\' || FullFileName[Position] == '/')
        {
            Directory[Position] = '\0';
            CreateDirectory(Directory, NULL);
        }

        Directory[Position] = FullFileName[Position];

        Position++;
    }
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ServerSend(int Client, char *String, int Length)
{
    while( !MyServer.SetSendDataEx(Client, String, Length) && MyServer.Connected[Client] )
        Sleep(1);

    return MyServer.Connected[Client];
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SimpleServerSend(int Client, char *Text)
{
    return ServerSend(Client, Text, strlen(Text));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool StartServer(void)
{
    if(gbServerRunning)
        return false;

    if(MyServer.Start(glListenPort))
    {
        EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_START, MF_GRAYED);
        EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_STOP, MF_ENABLED);
        EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_SETTINGS, MF_GRAYED);

        gbServerRunning = true;
        return true;
    }
    else{
        WriteLog("Failed to start server.");
        glErrorCount++;
        return false;
    }

    return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool StopServer(void)
{
    if(!gbServerRunning)
        return false;

    if(MyServer.Stop())
    {
        EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_START, MF_ENABLED);
        EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_STOP, MF_GRAYED);
        EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_SETTINGS, MF_ENABLED);

        gbServerRunning = false;
        return true;
    }
    else{
        WriteLog("Failed to stop server.");
        glErrorCount++;
        return false;
    }

    return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetRegistryValues(void)
{
	DWORD SizeofString = 0;

    SizeofString = sizeof(gsSessionLogDir);
	memset(gsSessionLogDir, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SessionLogDir", gsSessionLogDir, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLIndexServer);
	memset(gsSQLIndexServer, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLIndexServer", gsSQLIndexServer, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLIndexUserID);
	memset(gsSQLIndexUserID, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLIndexUserID", gsSQLIndexUserID, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLIndexPassword);
	memset(gsSQLIndexPassword, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLIndexPassword", gsSQLIndexPassword, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLIndexDatabase);
	memset(gsSQLIndexDatabase, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLIndexDatabase", gsSQLIndexDatabase, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLIndexDriver);
	memset(gsSQLIndexDriver, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLIndexDriver", gsSQLIndexDriver, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLCustServer);
	memset(gsSQLCustServer, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLCustServer", gsSQLCustServer, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLCustUserID);
	memset(gsSQLCustUserID, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLCustUserID", gsSQLCustUserID, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLCustPassword);
	memset(gsSQLCustPassword, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLCustPassword", gsSQLCustPassword, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLCustDriver);
	memset(gsSQLCustDriver, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLCustDriver", gsSQLCustDriver, SizeofString))
        return false;

    SizeofString = sizeof(gsBaseCommKey);
	memset(gsBaseCommKey, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "BaseCommKey", gsBaseCommKey, SizeofString))
        return false;

    SizeofString = sizeof(gsAuthString);
	memset(gsAuthString, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "AuthString", gsAuthString, SizeofString))
        return false;

    SizeofString = sizeof(gsClientFilesTemp);
	memset(gsClientFilesTemp, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "ClientFilesTemp", gsClientFilesTemp, SizeofString))
        return false;

    if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "MaxConnections", (DWORD &) giMaxConnections))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "TCPLoopDelay", glTCPLoopDelay))
        return false;

    if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "ListenPort", glListenPort))
        return false;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

